/* -LICENSE-START-
** Copyright (c) 2011 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
** 
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
** 
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/

#import "BMDStreamingDeckControlNotifier.h"
#import <Cocoa/Cocoa.h>

const REFIID kIID_IDeckLinkDeckControlStatusCallback = IID_IDeckLinkDeckControlStatusCallback;

SInt32 BMDStreamingDeckControlNotifier::TimecodeUpdate(BMDTimecodeBCD currentTimecode)
{
	NSAutoreleasePool* arp = [[NSAutoreleasePool alloc] init];
	[mDelegate timecodeUpdate:currentTimecode];
	[arp release];
	return 0;
}

SInt32 BMDStreamingDeckControlNotifier::VTRControlStateChanged(BMDDeckControlVTRControlState newState, BMDDeckControlError error)
{
	NSAutoreleasePool* arp = [[NSAutoreleasePool alloc] init];
	[mDelegate vtrControlStateChanged:newState error:error];
	[arp release];
	return 0;
}

SInt32 BMDStreamingDeckControlNotifier::DeckControlEventReceived(BMDDeckControlEvent event, BMDDeckControlError error)
{
	NSAutoreleasePool* arp = [[NSAutoreleasePool alloc] init];
	[mDelegate deckControlEventReceived:event error:error];
	[arp release];
	return 0;
}

SInt32 BMDStreamingDeckControlNotifier::DeckControlStatusChanged(BMDDeckControlStatusFlags flags, uint32_t mask)
{
	NSAutoreleasePool* arp = [[NSAutoreleasePool alloc] init];
	[mDelegate deckControlStatusChanged:flags mask:mask];
	[arp release];
	return 0;
}
